/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */   

/**
 * \file    ddr3.h
 *
 * \brief   Support routines for DDR test application
 *
 * This file contains the support function for DDR Test application.
 *
 * \author  0043
 *
 * \version 01a,13aug,2010 Created
 * \version 02a,12Aug,An, 2016 comments and codeupdated for the 
 *                             processor DM8127.
 */

#ifndef _DDR_2_H_
#define _DDR_2_H_

#define DDR0_CTRL		 0
#define DDR1_CTRL		 1

#define DDR0_BASE        0x80000000  // Start of DDR0
#define DDR0_SIZE        0x40000000  // 512 MB
#define DDR1_BASE        0xC0000000  // Start of DDR1
#define DDR1_SIZE        0x40000000  // 512 MB
#define DDR_BANK_SIZE	 0x01000000  

#define DDR_MEM_BANK	8
#define DDR0_BANK_NUM	(DDR_MEM_BANK + DDR_MEM_BANK + DDR_MEM_BANK + DDR_MEM_BANK)
#define DDR1_BANK_NUM	(DDR_MEM_BANK + DDR_MEM_BANK + DDR_MEM_BANK + DDR_MEM_BANK)
#define DDR_RW_SIZE		(16 * 1024)

/* ------------------------------------------------------------------------ *
 *  DDR0 Controller                                                         *
 * ------------------------------------------------------------------------ */
#define DDR_EMIF0_BASE  0x4C000000

/* ------------------------------------------------------------------------ *
 *  DDR1 Controller                                                         *
 * ------------------------------------------------------------------------ */
#define DDR_EMIF1_BASE  0x4D000000


/* ------------------------------------------------------------------------ *
 *  Prototype                                                               *
 * ------------------------------------------------------------------------ */
 /***
 * \brief: Routine to initialize ddr3
 */
void ddr3_init( );
/***
 * \brief: Routine to read from DDR3  memory
 *
 * \b \Descr: This routine reads from DDR3 memory.This routine takes buffer pointer
 * \n         as a parameter  from where data to be read along with that it contains
 * \n         buffer to copy read data and length of the buffer.
 *
 * \param:   *pSrc  [IN]  buffer pointer to read data
 * \n        *pDSt  [IN]  buffer pointer to copy read data
 * \n        length [IN]  length of the buffer
 */

void ddr3_read
(
	UINT16 *pSrc,
	UINT16 *pDst,
	UINT32 length
);
/***
 * \brief: Routine to write into ddr3
 *
 * \b Descr: This routine writes into ddr3.This routine takes pSrc buffer pointer
 * \n        as a parameter which contains data to be copied along with that pDst
 * \n        buffer pointer  which contains the address where to copy and lenght
 * \n        of the buffer
 *
 *
 * \param:   *pSrc   [IN]   buffer to be written into ddr3
 * \n        *pDst   [IN]   address where data to be written
 * \n        length  [IN]   length of the buffer
 *
 */

void ddr3_write
(
	UINT16 *pSrc,
	UINT16 *pDst,
	UINT32 length
);


/***
 * \brief: Routine to test the ddr3 with cache_enable option
 *
 * \b \Descr: This routine takes cache_enable option as a parameter and does DDR
 *            read write tests.
 *
 * \param: cache_enable [IN] cache_enable if required
 *
 * \return: SUCCESS for success  - Description
 * \n       FAILED for error   - Description
 *
 */

STATUS  DDR3_test
(
	void *cache_enable
);

/***
 * \brief:  Patter update function on DDR3 memory
 *
 * \b \Descr: This function write the given pattern into the DDR
 * \n         and verify it. it throw the messeage for a particular
 * \n         memory location if any error or data mismatch happen
 * \n         to that particular location.
 *
 * \param:  pu32BaseAddr [IN]  starting address of the DDR3 memory.
 *          u32Size      [IN]  size of memory location to be written
 *          u32Pattern   [IN]  Pattern to be written
 *
 * \return: SUCCESS  on successful memory write and verify
 * \n       FAILED   Memory data error
 */

STATUS ddr3MemoryDatatest
(
	UINT32* pu32BaseAddr,
	UINT32 u32Size,
	UINT32 U32pattern
);



/***
* \brief : Routine to test ddr3 memory.
*
* \b \Descr: This routine tests the ddr3 by writing into all banks and reading
*            from it then compares both .This routine takes  ddrctrl as parameter
*            to select the controller.
*
* \param   ddrctrl   [IN]   To select controller
*
* \return  0  for success  - Description
* \n        1  for error   - Description
*
*/
SINT16 ddr3_rw_test
(
	SINT16 ddrCtrl
);

/***
 * \brief:  Pattern update function on DDR3 memory
 *
 * \b \Descr: This function write the given pattern into the DDR
 * \n         and verify it. it throw the messeage for a particular
 * \n         memory location if any error or data mismatch happen
 *            to that particular location.
 *
 * \param:  pu32BaseAddr [IN]  starting address of the DDR3 memory.
 * \n       u32Size      [IN]  size of memory location to be written
 * \n       u32Pattern   [IN]  Pattern to be written
 *
 * \return: SUCCESS  on successful memory write and verify
 * \n       FAILED   Memory data error
 */

STATUS ddr3_pattern_test
(
	UINT32* pu32BaseAddr,
	UINT32 u32Size,
	UINT32 u32Pattern
);
#endif /* _DDR_2_H_ */
